/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWTablePrintable
implements IVWPrintable {
    protected static final String INDENTATION = "    ";
    private VWTable m_table = null;
    protected VWPrinter m_vwPrinter = null;
    private Vector m_columnSplit = new Vector();
    private boolean m_getColumnSplitVector = false;
    private int m_current = 0;
    private int m_oldPageIndex = 0;
    private int m_rowH = 0;
    private int m_rowPerPage = 0;
    private int m_headerSpace = 2;
    protected Graphics2D m_g2 = null;
    private int m_startRowToPrint = 0;
    private int m_endRowToPrint = 0;
    private int m_totalRows = 0;
    private int m_pageCount = 0;
    private Font m_tableHeaderFont = null;
    private Font m_tableCellFont = null;

    public VWTablePrintable(VWTable vwTable, Graphics g) {
        this.m_table = vwTable;
        this.m_g2 = (Graphics2D)g;
        this.init();
    }

    public void bindBook() {
        try {
            this.init();
            this.m_pageCount = this.calculatePageCount(this.m_vwPrinter.getPageFormat());
            if (this.m_pageCount > 0) {
                this.m_vwPrinter.appendBook(this, this.m_pageCount);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public void printSetup() {
        try {
            PageFormat pf = this.m_vwPrinter.getPageFormat();
            PrinterJob printerJob = this.m_vwPrinter.getPrinterJob();
            PageFormat pageFormat = printerJob.pageDialog(pf);
            printerJob.validatePage(pageFormat);
            if (pageFormat != pf) {
                this.m_vwPrinter.setPageFormat(pageFormat);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
    }

    public void setupVWPrinter(VWPrinter printer) {
        this.m_vwPrinter = printer;
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.m_totalRows < 1) {
            this.m_getColumnSplitVector = false;
            return 1;
        }
        pg.setFont(this.m_tableHeaderFont);
        pg.setColor(Color.black);
        FontMetrics fm = pg.getFontMetrics(pg.getFont());
        this.m_rowH = Math.max((int)((double)fm.getHeight() * 1.5), 20);
        if (!this.m_getColumnSplitVector) {
            this.m_current = 0;
            this.m_oldPageIndex = 0;
            this.getColumnSplit(pg, pageFormat, this.m_columnSplit);
            this.m_getColumnSplitVector = true;
            this.m_startRowToPrint = this.m_endRowToPrint;
            this.m_endRowToPrint = this.getEndRow(this.m_startRowToPrint, pg, pageFormat);
        }
        if (this.m_oldPageIndex != pageIndex) {
            if (this.m_current == this.m_columnSplit.size() - 1) {
                this.m_current = 0;
                this.m_startRowToPrint = this.m_endRowToPrint;
                this.m_endRowToPrint = this.getEndRow(this.m_startRowToPrint, pg, pageFormat);
            } else {
                ++this.m_current;
            }
        }
        if (this.m_endRowToPrint > this.m_totalRows || this.m_startRowToPrint == this.m_totalRows) {
            this.m_getColumnSplitVector = false;
            return 1;
        }
        this.PrintPage(pg, pageFormat, pageIndex);
        this.m_oldPageIndex = pageIndex;
        return 0;
    }

    public Graphics getGraphics() {
        return this.m_g2;
    }

    private void init() {
        this.m_getColumnSplitVector = false;
        this.m_current = 0;
        this.m_oldPageIndex = 0;
        this.m_rowH = 0;
        this.m_rowPerPage = 0;
        this.m_headerSpace = 2;
        this.m_startRowToPrint = 0;
        this.m_endRowToPrint = 0;
        this.getFont();
        this.m_totalRows = this.m_table.getRowCount();
    }

    private int calculatePageCount(PageFormat pf) {
        int numberOfPages = 0;
        this.m_g2.setFont(this.m_tableHeaderFont);
        this.m_g2.setColor(Color.black);
        this.getColumnSplit(this.m_g2, pf, this.m_columnSplit);
        numberOfPages = this.m_totalRows / this.m_rowPerPage;
        if (numberOfPages <= 0) {
            numberOfPages = 1;
        } else {
            int remainder = this.m_totalRows % this.m_rowPerPage;
            if (remainder > 0) {
                ++numberOfPages;
            }
        }
        return numberOfPages *= this.m_columnSplit.size();
    }

    private void getFont() {
        Font font = null;
        int nFontSize = 8;
        if (this.m_tableHeaderFont != null && this.m_tableCellFont != null) {
            return;
        }
        if (this.m_g2 == null) {
            this.m_g2 = (Graphics2D)this.m_table.getGraphics();
        }
        if (this.m_g2 != null) {
            try {
                font = this.m_g2.getFont();
                nFontSize = Integer.valueOf("8");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            if (font != null) {
                this.m_tableHeaderFont = new Font(font.getName(), 1, nFontSize);
                this.m_tableCellFont = new Font(font.getName(), 0, nFontSize);
            }
        }
    }

    private void PrintPage(Graphics pg, PageFormat pageFormat, int pageIndex) {
        int x;
        int j;
        int X = (int)pageFormat.getImageableX();
        int Y = (int)pageFormat.getImageableY();
        pg.translate(X + 2, Y);
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        FontMetrics fm = pg.getFontMetrics(pg.getFont());
        int y = 0;
        y = (int)((double)y + (double)fm.getHeight() * 1.5);
        int[] currentHeader = (int[])this.m_columnSplit.elementAt(this.m_current);
        int currentColumn = currentHeader[0];
        int length = Array.getLength(currentHeader);
        int lineWhere = (this.m_rowH - fm.getHeight()) / 2;
        int right = currentHeader[length - 1];
        int padding = 30;
        int rightOffset = wPage - this.m_headerSpace - padding;
        pg.setFont(this.m_tableHeaderFont);
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (j = 1; j < length - 1; ++j) {
            TableColumn tk = colModel.getColumn(currentColumn);
            if (tk.getIdentifier() instanceof VWTableHeaderRenderer) {
                VWTableHeaderRenderer th = (VWTableHeaderRenderer)tk.getIdentifier();
                Image img = ((ImageIcon)th.getIcon()).getImage();
                pg.drawImage(img, currentHeader[j], y - 15, this.m_table);
            } else {
                String title = (String)tk.getIdentifier();
                pg.drawString(title, currentHeader[j], y);
            }
            x = currentHeader[j];
            pg.drawLine(x -= this.m_headerSpace, 0, x, y + lineWhere);
            ++currentColumn;
        }
        x = currentHeader[j];
        pg.drawLine(x, 0, x, y + lineWhere);
        pg.drawLine(0, 0, right, 0);
        pg.drawLine(0, y + lineWhere, right, y + lineWhere);
        pg.setFont(this.m_tableCellFont);
        int cellHeight = 1;
        for (int nRow = this.m_startRowToPrint; nRow < this.m_endRowToPrint; ++nRow) {
            currentColumn = currentHeader[0];
            y += this.m_rowH;
            j = 1;
            while (j < length - 1) {
                cellHeight = 1;
                TableColumn tk = colModel.getColumn(currentColumn);
                int modelColIndex = this.m_table.convertColumnIndexToModel(currentColumn);
                Object obj = this.m_table.getModel().getValueAt(nRow, modelColIndex);
                if (obj == null) {
                    this.m_table.drawNullObject(pg, nRow, currentColumn, currentHeader[j], y);
                } else if (obj instanceof ImageIcon) {
                    pg.drawImage(((ImageIcon)obj).getImage(), currentHeader[j], y - 15, this.m_table);
                } else {
                    String cell;
                    if (obj != null && obj instanceof VWAdminFieldsTableData) {
                        obj = ((VWAdminFieldsTableData)obj).getValue();
                    }
                    if (tk.getCellRenderer() instanceof VWFieldsCellRenderer) {
                        VWFieldsCellRenderer renderer = (VWFieldsCellRenderer)tk.getCellRenderer();
                        cell = VWFieldsCellRenderer.toString(obj);
                    } else {
                        cell = obj.toString();
                    }
                    if (cell != null && VWStringUtils.compareIgnoreCase(cell, "") != 0) {
                        int len = fm.stringWidth(cell);
                        if (len >= rightOffset) {
                            int charsPerRow = cell.length() * rightOffset / len;
                            int beginIndex = 0;
                            int endIndex = charsPerRow;
                            cellHeight = this.getCellHeight(pg, pageFormat, cell);
                            for (int i = 0; i < cellHeight && endIndex <= cell.length() && beginIndex != endIndex; ++i) {
                                String val = cell.substring(beginIndex, endIndex);
                                beginIndex = endIndex;
                                if ((endIndex = beginIndex + charsPerRow) >= cell.length()) {
                                    endIndex = cell.length();
                                }
                                if (i != 0) {
                                    y += this.m_rowH;
                                }
                                pg.drawString(val, currentHeader[j], y);
                                pg.drawLine(currentHeader[j] - this.m_headerSpace, y - this.m_rowH, currentHeader[j] - this.m_headerSpace, y + lineWhere);
                            }
                        } else {
                            pg.drawString(cell, currentHeader[j], y);
                        }
                    }
                }
                pg.drawLine(currentHeader[j] - this.m_headerSpace, y - this.m_rowH, currentHeader[j] - this.m_headerSpace, y + lineWhere);
                ++j;
                ++currentColumn;
            }
            pg.drawLine(currentHeader[j], y - this.m_rowH * cellHeight, currentHeader[j], y + lineWhere);
            pg.drawLine(0, y + lineWhere, right, y + lineWhere);
        }
        int splitNumber = this.m_columnSplit.size();
        String pageNumber = "" + (pageIndex / splitNumber + 1);
        if (splitNumber > 1) {
            pageNumber = pageNumber + "-" + (this.m_current + 1);
        }
        pg.drawString(pageNumber, wPage / 2, hPage - 2);
    }

    private void getColumnSplit(Graphics pg, PageFormat pageFormat, Vector columnSplit) {
        columnSplit.removeAllElements();
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        FontMetrics fm = pg.getFontMetrics(pg.getFont());
        int padding = 30;
        int rightOffset = wPage - this.m_headerSpace - padding;
        TableColumnModel colModel = this.m_table.getColumnModel();
        int nColumns = colModel.getColumnCount();
        int[] temp = new int[nColumns + 1];
        temp[0] = this.m_headerSpace;
        int count = 0;
        int firstColumn = 0;
        for (int nCol = 0; nCol < nColumns; ++nCol) {
            TableColumn tk = colModel.getColumn(nCol);
            String title = tk.getIdentifier() instanceof VWTableHeaderRenderer ? "XXXXX" : (String)tk.getIdentifier();
            int titleWidth = fm.stringWidth(title);
            int modelColIndex = this.m_table.convertColumnIndexToModel(nCol);
            for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                String str;
                Object obj = this.m_table.getModel().getValueAt(i, modelColIndex);
                if (obj == null || obj instanceof ImageIcon) continue;
                if (tk.getCellRenderer() instanceof VWFieldsCellRenderer) {
                    VWFieldsCellRenderer renderer = (VWFieldsCellRenderer)tk.getCellRenderer();
                    str = VWFieldsCellRenderer.toString(obj);
                } else {
                    str = obj.toString();
                }
                if (str != null && fm.stringWidth(str) > titleWidth && (titleWidth = fm.stringWidth(str)) > rightOffset) break;
            }
            if (temp[count] + titleWidth > rightOffset) {
                if (count != 0) {
                    int[] x = new int[count + 2];
                    x[0] = firstColumn;
                    for (int j = 0; j <= count; ++j) {
                        x[j + 1] = temp[j];
                    }
                    this.m_columnSplit.addElement(x);
                    temp[0] = this.m_headerSpace;
                    count = 0;
                    firstColumn = nCol--;
                    continue;
                }
                int[] x = new int[]{firstColumn, this.m_headerSpace, rightOffset};
                this.m_columnSplit.addElement(x);
                temp[0] = this.m_headerSpace;
                count = 0;
                firstColumn = nCol + 1;
                continue;
            }
            temp[count + 1] = temp[count] + titleWidth + padding;
            ++count;
        }
        if (count > 0) {
            int[] x = new int[count + 2];
            x[0] = firstColumn;
            for (int j = 0; j <= count; ++j) {
                x[j + 1] = temp[j];
            }
            this.m_columnSplit.addElement(x);
        }
        int header = 0;
        header = (int)((double)header + (double)fm.getHeight() * 1.5 * 2.0);
        this.m_rowH = Math.max((int)((double)fm.getHeight() * 1.5), 20);
        this.m_rowPerPage = (hPage - header) / this.m_rowH;
    }

    private int getCellHeight(Graphics pg, PageFormat pageFormat, String cell) {
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        FontMetrics fm = pg.getFontMetrics();
        int rightOffset = wPage - this.m_headerSpace - 30;
        int len = (int)((double)fm.stringWidth(cell) * 1.2);
        if (len >= rightOffset) {
            int rows = len / rightOffset;
            if (len % rightOffset > 0) {
                ++rows;
            }
            return rows;
        }
        return 1;
    }

    private int getEndRow(int startRow, Graphics pg, PageFormat pageFormat) {
        int nRow;
        TableColumnModel colModel = this.m_table.getColumnModel();
        int totalCols = colModel.getColumnCount();
        int numRowsPerPage = 0;
        for (nRow = startRow; nRow < this.m_totalRows; ++nRow) {
            int cellHeight = 1;
            for (int j = 0; j < totalCols; ++j) {
                int height;
                String cell;
                TableColumn tk = colModel.getColumn(j);
                int modelColIndex = this.m_table.convertColumnIndexToModel(j);
                Object obj = this.m_table.getModel().getValueAt(nRow, modelColIndex);
                if (obj == null || obj instanceof ImageIcon) continue;
                if (tk.getCellRenderer() instanceof VWFieldsCellRenderer) {
                    VWFieldsCellRenderer renderer = (VWFieldsCellRenderer)tk.getCellRenderer();
                    cell = VWFieldsCellRenderer.toString(obj);
                } else {
                    cell = obj.toString();
                }
                if (cell == null || VWStringUtils.compareIgnoreCase(cell, "") == 0 || (height = this.getCellHeight(pg, pageFormat, cell)) <= cellHeight) continue;
                cellHeight = height;
            }
            if ((numRowsPerPage += cellHeight) <= this.m_rowPerPage) continue;
            return nRow;
        }
        return nRow;
    }
}

